---
title: Tutorials · Cloudflare Workers docs
description: View tutorials to help you get started with Workers.
lastUpdated: 2025-10-31T11:34:53.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/tutorials/
  md: https://developers.cloudflare.com/workers/tutorials/index.md
---

View tutorials to help you get started with Workers.

## Docs

| Name | Last Updated | Type | Difficulty |
| - | - | - | - |
| [Deploy an Express.js application on Cloudflare Workers](https://developers.cloudflare.com/workers/tutorials/deploy-an-express-app/) | 19 days ago | 📝 Tutorial | Beginner |
| [Connect to a PostgreSQL database with Cloudflare Workers](https://developers.cloudflare.com/workers/tutorials/postgres/) | 4 months ago | 📝 Tutorial | Beginner |
| [Query D1 using Prisma ORM](https://developers.cloudflare.com/d1/tutorials/d1-and-prisma-orm/) | 5 months ago | 📝 Tutorial | Beginner |
| [Migrate from Netlify to Workers](https://developers.cloudflare.com/workers/static-assets/migration-guides/netlify-to-workers/) | 6 months ago | 📝 Tutorial | Beginner |
| [Migrate from Vercel to Workers](https://developers.cloudflare.com/workers/static-assets/migration-guides/vercel-to-workers/) | 7 months ago | 📝 Tutorial | Beginner |
| [Connect to a MySQL database with Cloudflare Workers](https://developers.cloudflare.com/workers/tutorials/mysql/) | 7 months ago | 📝 Tutorial | Beginner |
| [Set up and use a Prisma Postgres database](https://developers.cloudflare.com/workers/tutorials/using-prisma-postgres-with-workers/) | 9 months ago | 📝 Tutorial | Beginner |
| [Store and Catalog AI Generated Images with R2 (Part 3)](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/image-generator-store-and-catalog/) | 9 months ago | 📝 Tutorial | Beginner |
| [Build a Retrieval Augmented Generation (RAG) AI](https://developers.cloudflare.com/workers-ai/guides/tutorials/build-a-retrieval-augmented-generation-ai/) | 12 months ago | 📝 Tutorial | Beginner |
| [Using BigQuery with Workers AI](https://developers.cloudflare.com/workers-ai/guides/tutorials/using-bigquery-with-workers-ai/) | about 1 year ago | 📝 Tutorial | Beginner |
| [Add New AI Models to your Playground (Part 2)](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/image-generator-flux-newmodels/) | about 1 year ago | 📝 Tutorial | Beginner |
| [Build an AI Image Generator Playground (Part 1)](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/image-generator-flux/) | about 1 year ago | 📝 Tutorial | Beginner |
| [How to Build an Image Generator using Workers AI](https://developers.cloudflare.com/workers-ai/guides/tutorials/image-generation-playground/) | about 1 year ago | 📝 Tutorial | Beginner |
| [Use event notification to summarize PDF files on upload](https://developers.cloudflare.com/r2/tutorials/summarize-pdf/) | about 1 year ago | 📝 Tutorial | Intermediate |
| [Build a Comments API](https://developers.cloudflare.com/d1/tutorials/build-a-comments-api/) | about 1 year ago | 📝 Tutorial | Intermediate |
| [Handle rate limits of external APIs](https://developers.cloudflare.com/queues/tutorials/handle-rate-limits/) | about 1 year ago | 📝 Tutorial | Beginner |
| [Build an API to access D1 using a proxy Worker](https://developers.cloudflare.com/d1/tutorials/build-an-api-to-access-d1/) | about 1 year ago | 📝 Tutorial | Intermediate |
| [Deploy a Worker](https://developers.cloudflare.com/pulumi/tutorial/hello-world/) | about 1 year ago | 📝 Tutorial | Beginner |
| [Build a web crawler with Queues and Browser Rendering](https://developers.cloudflare.com/queues/tutorials/web-crawler-with-browser-rendering/) | over 1 year ago | 📝 Tutorial | Intermediate |
| [Create a fine-tuned OpenAI model with R2](https://developers.cloudflare.com/workers/tutorials/create-finetuned-chatgpt-ai-models-with-r2/) | over 1 year ago | 📝 Tutorial | Intermediate |
| [Build a Slackbot](https://developers.cloudflare.com/workers/tutorials/build-a-slackbot/) | over 1 year ago | 📝 Tutorial | Beginner |
| [Use Workers KV directly from Rust](https://developers.cloudflare.com/workers/tutorials/workers-kv-from-rust/) | over 1 year ago | 📝 Tutorial | Intermediate |
| [Build a todo list Jamstack application](https://developers.cloudflare.com/workers/tutorials/build-a-jamstack-app/) | over 1 year ago | 📝 Tutorial | Beginner |
| [Send Emails With Postmark](https://developers.cloudflare.com/workers/tutorials/send-emails-with-postmark/) | over 1 year ago | 📝 Tutorial | Beginner |
| [Send Emails With Resend](https://developers.cloudflare.com/workers/tutorials/send-emails-with-resend/) | over 1 year ago | 📝 Tutorial | Beginner |
| [Log and store upload events in R2 with event notifications](https://developers.cloudflare.com/r2/tutorials/upload-logs-event-notifications/) | over 1 year ago | 📝 Tutorial | Beginner |
| [Create custom headers for Cloudflare Access-protected origins with Workers](https://developers.cloudflare.com/cloudflare-one/tutorials/access-workers/) | almost 2 years ago | 📝 Tutorial | Intermediate |
| [Create a serverless, globally distributed time-series API with Timescale](https://developers.cloudflare.com/hyperdrive/tutorials/serverless-timeseries-api-with-timescale/) | about 2 years ago | 📝 Tutorial | Beginner |
| [Deploy a Browser Rendering Worker with Durable Objects](https://developers.cloudflare.com/browser-rendering/workers-bindings/browser-rendering-with-do/) | about 2 years ago | 📝 Tutorial | Beginner |
| [Tutorial - React SPA with an API](https://developers.cloudflare.com/workers/vite-plugin/tutorial/) | | 📝 Tutorial | |
| [GitHub SMS notifications using Twilio](https://developers.cloudflare.com/workers/tutorials/github-sms-notifications-using-twilio/) | about 2 years ago | 📝 Tutorial | Beginner |
| [Deploy a real-time chat application](https://developers.cloudflare.com/workers/tutorials/deploy-a-realtime-chat-app/) | about 2 years ago | 📝 Tutorial | Intermediate |
| [Build a QR code generator](https://developers.cloudflare.com/workers/tutorials/build-a-qr-code-generator/) | over 2 years ago | 📝 Tutorial | Beginner |
| [Securely access and upload assets with Cloudflare R2](https://developers.cloudflare.com/workers/tutorials/upload-assets-with-r2/) | over 2 years ago | 📝 Tutorial | Beginner |
| [OpenAI GPT function calling with JavaScript and Cloudflare Workers](https://developers.cloudflare.com/workers/tutorials/openai-function-calls-workers/) | over 2 years ago | 📝 Tutorial | Beginner |
| [Handle form submissions with Airtable](https://developers.cloudflare.com/workers/tutorials/handle-form-submissions-with-airtable/) | over 2 years ago | 📝 Tutorial | Beginner |
| [Connect to and query your Turso database using Workers](https://developers.cloudflare.com/workers/tutorials/connect-to-turso-using-workers/) | over 2 years ago | 📝 Tutorial | Beginner |
| [Generate YouTube thumbnails with Workers and Cloudflare Image Resizing](https://developers.cloudflare.com/workers/tutorials/generate-youtube-thumbnails-with-workers-and-images/) | over 2 years ago | 📝 Tutorial | Intermediate |

## Videos

OpenAI Relay Server on Cloudflare Workers

In this video, Craig Dennis walks you through the deployment of OpenAI's relay server to use with their realtime API.

Deploy your React App to Cloudflare Workers

Learn how to deploy an existing React application to Cloudflare Workers.

Cloudflare Workflows | Schedule and Sleep For Your Apps (Part 3 of 3)

Cloudflare Workflows allows you to initiate sleep as an explicit step, which can be useful when you want a Workflow to wait, schedule work ahead, or pause until an input or other external state is ready.

Cloudflare Workflows | Introduction (Part 1 of 3)

In this video, we introduce Cloudflare Workflows, the Newest Developer Platform Primitive at Cloudflare.

Cloudflare Workflows | Batching and Monitoring Your Durable Execution (Part 2 of 3)

Workflows exposes metrics such as execution, error rates, steps, and total duration!

Building Front-End Applications | Now Supported by Cloudflare Workers

You can now build front-end applications, just like you do on Cloudflare Pages, but with the added benefit of Workers.

Build a private AI chatbot using Meta's Llama 3.1

In this video, you will learn how to set up a private AI chat powered by Llama 3.1 for secure, fast interactions, deploy the model on Cloudflare Workers for serverless, scalable performance and use Cloudflare's Workers AI for seamless integration and edge computing benefits.

How to Build Event-Driven Applications with Cloudflare Queues

In this video, we demonstrate how to build an event-driven application using Cloudflare Queues. Event-driven system lets you decouple services, allowing them to process and scale independently.

Welcome to the Cloudflare Developer Channel

Welcome to the Cloudflare Developers YouTube channel. We've got tutorials and working demos and everything you need to level up your projects. Whether you're working on your next big thing or just dorking around with some side projects, we've got you covered! So why don't you come hang out, subscribe to our developer channel and together we'll build something awesome. You're gonna love it.

AI meets Maps | Using Cloudflare AI, Langchain, Mapbox, Folium and Streamlit

Welcome to RouteMe, a smart tool that helps you plan the most efficient route between landmarks in any city. Powered by Cloudflare Workers AI, Langchain and Mapbox. This Streamlit webapp uses LLMs and Mapbox off my scripts API to solve the classic traveling salesman problem, turning your sightseeing into an optimized adventure!

Use Vectorize to add additional context to your AI Applications through RAG

A RAG based AI Chat app that uses Vectorize to access video game data for employees of Gamertown.

Build Rust Powered Apps

In this video, we will show you how to build a global database using workers-rs to keep track of every country and city you’ve visited.

Stateful Apps with Cloudflare Workers

Learn how to access external APIs, cache and retrieve data using Workers KV, and create SQL-driven applications with Cloudflare D1.

Learn Cloudflare Workers - Full Course for Beginners

Learn how to build your first Cloudflare Workers application and deploy it to Cloudflare's global network.

Learn AI Development (models, embeddings, vectors)

In this workshop, Kristian Freeman, Cloudflare Developer Advocate, teaches the basics of AI Development - models, embeddings, and vectors (including vector databases).

Optimize your AI App & fine-tune models (AI Gateway, R2)

In this workshop, Kristian Freeman, Cloudflare Developer Advocate, shows how to optimize your existing AI applications with Cloudflare AI Gateway, and how to finetune OpenAI models using R2.

How to use Cloudflare AI models and inference in Python with Jupyter Notebooks

Cloudflare Workers AI provides a ton of AI models and inference capabilities. In this video, we will explore how to make use of Cloudflare’s AI model catalog using a Python Jupyter Notebook.
