---
title: Deploy a real-time chat application · Cloudflare Workers docs
description: This tutorial shows how to deploy a serverless, real-time chat
  application. The chat application uses a Durable Object to control each chat
  room.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: JavaScript
source_url:
  html: https://developers.cloudflare.com/workers/tutorials/deploy-a-realtime-chat-app/
  md: https://developers.cloudflare.com/workers/tutorials/deploy-a-realtime-chat-app/index.md
---

In this tutorial, you will deploy a serverless, real-time chat application that runs using [Durable Objects](https://developers.cloudflare.com/durable-objects/).

This chat application uses a Durable Object to control each chat room. Users connect to the Object using WebSockets. Messages from one user are broadcast to all the other users. The chat history is also stored in durable storage. Real-time messages are relayed directly from one user to others without going through the storage layer.

## Before you start

All of the tutorials assume you have already completed the [Get started guide](https://developers.cloudflare.com/workers/get-started/guide/), which gets you set up with a Cloudflare Workers account, [C3](https://github.com/cloudflare/workers-sdk/tree/main/packages/create-cloudflare), and [Wrangler](https://developers.cloudflare.com/workers/wrangler/install-and-update/).

## Clone the chat application repository

Open your terminal and clone the [workers-chat-demo](https://github.com/cloudflare/workers-chat-demo) repository:

```sh
git clone https://github.com/cloudflare/workers-chat-demo.git
```

## Authenticate Wrangler

After you have cloned the repository, authenticate Wrangler by running:

```sh
npx wrangler login
```

## Deploy your project

When you are ready to deploy your application, run:

```sh
npx wrangler deploy
```

Your application will be deployed to your `*.workers.dev` subdomain.

To deploy your application to a custom domain within the Cloudflare dashboard, go to your Worker > **Triggers** > **Add Custom Domain**.

To deploy your application to a custom domain using Wrangler, open your project's [Wrangler configuration file](https://developers.cloudflare.com/workers/wrangler/configuration/).

To configure a route in your Wrangler configuration file, add the following to your environment:

* wrangler.jsonc

  ```jsonc
  {
    "$schema": "./node_modules/wrangler/config-schema.json",
    "routes": [
      {
        "pattern": "example.com/about",
        "zone_id": "<YOUR_ZONE_ID>"
      }
    ]
  }
  ```

* wrangler.toml

  ```toml
  [[routes]]
  pattern = "example.com/about"
  zone_id = "<YOUR_ZONE_ID>"
  ```

If you have specified your zone ID in the environment of your Wrangler configuration file, you will not need to write it again in object form.

To configure a subdomain in your Wrangler configuration file, add the following to your environment:

* wrangler.jsonc

  ```jsonc
  {
    "$schema": "./node_modules/wrangler/config-schema.json",
    "routes": [
      {
        "pattern": "subdomain.example.com",
        "custom_domain": true
      }
    ]
  }
  ```

* wrangler.toml

  ```toml
  [[routes]]
  pattern = "subdomain.example.com"
  custom_domain = true
  ```

To test your live application:

1. In the Cloudflare dashboard, go to the **Workers & Pages** page.

   [Go to **Workers & Pages**](https://dash.cloudflare.com/?to=/:account/workers-and-pages)

2. Select your Worker > **Triggers** > **Routes** > Select the `edge-chat-demo.<SUBDOMAIN>.workers.dev` route.

3. Enter a name in the **your name** field.

4. Choose whether to enter a public room or create a private room.

5. Send the link to other participants. You will be able to view room participants on the right side of the screen.

## Uninstall your application

To uninstall your chat application, modify your Wrangler file to remove the `durable_objects` bindings and add a `deleted_classes` migration:

* wrangler.jsonc

  ```jsonc
  {
    "$schema": "./node_modules/wrangler/config-schema.json",
    "durable_objects": {
      "bindings": []
    },
    "migrations": [
      {
        "tag": "v1",
        "new_sqlite_classes": [
          "ChatRoom",
          "RateLimiter"
        ]
      },
      {
        "tag": "v2",
        "deleted_classes": [
          "ChatRoom",
          "RateLimiter"
        ]
      }
    ]
  }
  ```

* wrangler.toml

  ```toml
  [durable_objects]
  bindings = [
  ]


  # Indicate that you want the ChatRoom and RateLimiter classes to be callable as Durable Objects.
  [[migrations]]
  tag = "v1" # Should be unique for each entry
  new_sqlite_classes = ["ChatRoom", "RateLimiter"]


  [[migrations]]
  tag = "v2"
  deleted_classes = ["ChatRoom", "RateLimiter"]
  ```

Then run `npx wrangler deploy`.

To delete your Worker:

1. In the Cloudflare dashboard, go to the **Workers & Pages** page.

   [Go to **Workers & Pages**](https://dash.cloudflare.com/?to=/:account/workers-and-pages)

2. In **Overview**, select your Worker.

3. Select **Manage Service** > **Delete**. For complete instructions on set up and deletion, refer to the `README.md` in your cloned repository.

By completing this tutorial, you have deployed a real-time chat application with Durable Objects and Cloudflare Workers.

## Related resources

Continue building with other Cloudflare Workers tutorials below.

* [Build a Slackbot](https://developers.cloudflare.com/workers/tutorials/build-a-slackbot/)
* [Create SMS notifications for your GitHub repository using Twilio](https://developers.cloudflare.com/workers/tutorials/github-sms-notifications-using-twilio/)
* [Build a QR code generator](https://developers.cloudflare.com/workers/tutorials/build-a-qr-code-generator/)
